#include <stdio.h>
#include <string.h>

#include "Base64Codec.h"


void main(void)
{
char Base64buf[1024];
int nResult;
Base64Codec aCodec;
char BinBuf[1024];

char* testString;


testString = "Wherever you go, there you are.";


printf("Test string: \"%s\" (len=%d)\n\n", testString, strlen(testString) );

printf("The codec estimates that %d bytes are needed to encode this string.\n", 
			aCodec.EstimateBase64EncodeSize( strlen(testString)) );

nResult = aCodec.Encode( Base64buf, 1023 , testString , strlen(testString) );
printf("\nResult Code: %2d characters in Base64 stream.\nOriginal Data: %-10s\nBase64 Stream: %-10s\n\n", nResult, testString, Base64buf );


nResult = aCodec.Decode(BinBuf,1023,Base64buf);

printf("\n\nDecode: %2d bytes of data\n\n", nResult );

BinBuf[nResult]=0;
printf("Decode as string: %s\n", BinBuf );



strcpy(Base64buf,"TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlz\
IHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2Yg\
dGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGlu\
dWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRo\
ZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=");


nResult = aCodec.EstimateBase64DecodeSize(Base64buf);

printf("\nCodec estimates %d bytes in this data stream.\n", nResult);

nResult = aCodec.Decode(BinBuf,1023,Base64buf);
printf("\n\nDecoded %2d bytes of binary data\n\n", nResult );

BinBuf[nResult]=0;
printf("Decode as string: %s\n", BinBuf );

}