// Base64GUIDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Base64GUI.h"
#include "Base64GUIDlg.h"
#include "Base64Codec.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBase64GUIDlg dialog

CBase64GUIDlg::CBase64GUIDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBase64GUIDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBase64GUIDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBase64GUIDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBase64GUIDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBase64GUIDlg, CDialog)
	//{{AFX_MSG_MAP(CBase64GUIDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_CHANGE(IDC_ASCII, OnChangeAscii)
	ON_EN_CHANGE(IDC_BASE64, OnChangeBase64)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBase64GUIDlg message handlers

BOOL CBase64GUIDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	SetDlgItemText(IDC_STATUS, "Type or paste into either the ASCII or Base64 window to begin.");

	SetControlFonts();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBase64GUIDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CBase64GUIDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CBase64GUIDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CBase64GUIDlg::OnChangeAscii() 
{
char *base64Data;
Base64Codec aCodec;
int nLength;
CString aString;

GetDlgItemText(IDC_ASCII, aString);


nLength = aCodec.EstimateBase64EncodeSize( aString.GetLength() );

base64Data = new char[nLength + 128];

nLength = aCodec.Encode(base64Data,nLength+1,(char*) LPCTSTR( aString), aString.GetLength() );
base64Data[nLength] = 0;

SetDlgItemText(IDC_BASE64,base64Data);

delete[] base64Data;


if (aString.GetLength() > 0)
	aString.Format("Converted %d ASCII characters to %d Base64 symbols.",
				aString.GetLength(), nLength);

	else
	aString.Format("The input data set is empty, so no Base64 representation is possible.");

SetDlgItemText(IDC_STATUS, aString);
}

void CBase64GUIDlg::OnChangeBase64() 
{
char *asciiData;
Base64Codec aCodec;
int nLength;
CString aString;

GetDlgItemText(IDC_BASE64, aString);


nLength = aCodec.EstimateBase64DecodeSize( (char*) LPCTSTR(aString) );

asciiData = new char[nLength + 128];

nLength = aCodec.Decode(asciiData,nLength+16,(char*) LPCTSTR(aString));

if (nLength > 0)
	{
	asciiData[nLength] = 0;
	SetDlgItemText(IDC_ASCII,asciiData);
	aString.Format("Decoded %d ASCII bytes from the Base64 data.", nLength );
	}
	else
	{
	SetDlgItemText(IDC_ASCII," (Unable to decode stream)");
	aString.Format("An error exists in the Base64 data, so unable to decode it.");
	}

SetDlgItemText(IDC_STATUS, aString);
delete[] asciiData;
}

//
// Set up fonts for the edit windows here
//

LOGFONT editFont;
CFont* m_pFont;

void CBase64GUIDlg::SetControlFonts()
{
memset(&editFont, 0, sizeof(editFont));
editFont.lfHeight = 12;
editFont.lfWeight = FW_REGULAR;
editFont.lfPitchAndFamily = DEFAULT_PITCH;
CString szFont("Courier");	// True-Type fixed-pitch font
lstrcpy(editFont.lfFaceName, szFont);

if (m_pFont)
	{
	delete m_pFont;	// MUST delete old font to deselect it from the control!
	}

m_pFont = new CFont();
m_pFont->CreateFontIndirect(&editFont);



CEdit* pC = (CEdit*) GetDlgItem(IDC_ASCII);
pC->SetFont(m_pFont);

pC = (CEdit*) GetDlgItem(IDC_BASE64);
pC->SetFont(m_pFont);
}
