// InetAddress.cpp: implementation of the InetAddress class.
//
// This class encapsulates IP addresses. It can be used with the
// Socket, ServerSocket, and DatagramSocket classes, or separately.
//
//////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "InetAddress.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction
//
// You can construct an InetAddress object by passing the string representing
// the hostname as a FQDN, or a string in dotted-decimal format. Either way, the
// constructor will attempt to convert into a binary IP address, using DNS
// services if required (alpha host entry).
//
// To check success, use the method "GetIP()" and check for a zero result,
// which indicates an invalid IP address.
//
//////////////////////////////////////////////////////////////////////

InetAddress::InetAddress(char* szHost)
{
hostent* remhost;
unsigned int addr;		// Used to hold IP address (binary)


m_DestIP = 0;	// ZERO for this value means that no valid address is held in this
				// InetAddress object


//
// If object was constructed in a default manner, do nothing more.
//
if (szHost == NULL) return;	

//
// Something was passed; try to convert it to a binary IP address 
//

//
// If the hostname starts with alpha character, use DNS services to resolve it.
//

if (isalpha(*szHost))
	{
	remhost = ::gethostbyname(szHost);	// Use DNS to lookup the host.

	if (WSAGetLastError() == WSAHOST_NOT_FOUND ) return; // ERROR: Host not found

	if (remhost == NULL) return;		// ERROR: unable to do anything further	

	//
	// Convert the address data in the structure pointed by *remhost into a 
	// SOCKADDR_IN structure for opening the socket.
	// The SOCKADDR_IN structure holds the destination address, port, and address
	// family identifier.
	//
	// First, test the data in the *remhost structure.
	//

	if (remhost->h_addrtype != AF_INET ) return;	// ERROR: Not an IP address, can't process

	if (remhost->h_addr_list[0] == NULL) return; // ERROR: No address data returned

	//
	// copy the resolve destination address, address family, and dest port information.
	//

	m_DestIP =  *((unsigned long*) remhost->h_addr_list[0]);
	return;
	}
	else
//
// Otherwise, just convert the ASCII representation of the host IP into binary.
//
	{
	addr = inet_addr(szHost);
	m_DestIP = addr;
	return;
	}





}

InetAddress::~InetAddress()
{

}

unsigned long InetAddress::GetIP()
{
return m_DestIP;
}

InetAddress::InetAddress(unsigned long nBinaryIP)
{
m_DestIP = nBinaryIP;
}

///////////////////////////////////////////////////////////////////////////////////
//
// Return an ASCII string containing the IPv4 address.
//
// Caller should supply a buffer at least 32 bytes long.
//
// WARNINGS: (1) No IPv6 support yet;
//           (2) NOT MACHINE INDEPENDENT
//
////////////////////////////////////////////////////////////////////////////////////

char* InetAddress::GetStringIP(char *szBuf)
{
unsigned char* buf = (unsigned char*) &m_DestIP;

sprintf(szBuf,"%d.%d.%d.%d", buf[0], buf[1], buf[2], buf[3] );

return szBuf;
}
