// Socket.h: interface for the Socket class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SOCKET_H__ADAD575B_6767_4124_BA2B_BC4D691AC591__INCLUDED_)
#define AFX_SOCKET_H__ADAD575B_6767_4124_BA2B_BC4D691AC591__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <winsock2.h>
#include "InetAddress.h"	// Added by ClassView

class Socket  
{
public:
	void SetSO_SNDBUF(int nBufSize);
	int GetSO_SNDBUF();
	Socket(InetAddress& dest, int nPort);
	InetAddress* GetRemoteAddress();
	InetAddress* GetLocalAddress();
	int GetSoTimeout();
	int GetLocalPort();
	int GetStatus();
	static int WSAStartup();
	int ReadLine(char* szBuf, int nMaxChars, char cTerminator = 0x0d );
	static WSADATA m_Data;				// Used for WSAInit() call [Optional]

	static int SOCK_ERROR;
	static int SOCK_TIMEOUT;
	static int SOCK_NODATA;

	int Read(void* lpBuf, int nBytesToRead);
	void SetSoTimeout(int nMilli);
	int Write(void* buf, int nBytes);
	int Write(char* szData);
	Socket(char* szHost, int nPort);
	void Close();
	Socket(SOCKET& sock, SOCKADDR_IN& addr);
	Socket();
	virtual ~Socket();





protected:
	int m_nTimeout;
	int m_nStatus;
	SOCKET m_rcvSocket;		// SOCKET structure associated with this object
	int m_PORT;				// Port number this ServerSocket will connect to
	unsigned long m_DestIP;		// Destination IP address in binary
	SOCKADDR_IN m_destSockAddr;	// Address structure for this socket

};

#endif // !defined(AFX_SOCKET_H__ADAD575B_6767_4124_BA2B_BC4D691AC591__INCLUDED_)
