// SocketTest.cpp : Defines the entry point for the console application.
//

#include <winsock2.h>
#include "stdafx.h"
#include "Socket.h"
#include "ServerSocket.h"
#include "DatagramSocket.h"
#include "InetAddress.h"

#define WEB_PORT 80

void WebSurfTest()
{
char host[128];
char pathname[128];
char buf[10240]; // receive buffer for web page data
int nResult;
int nBytesReceived;

fflush(stdin);
printf("Hostname to connect to for Web browse >");
gets(host);

fflush(stdin);
printf("Folder to retrieve (ENTER for default '/' folder) >");
gets(pathname);

if (strlen(pathname)==0)
	strcpy(pathname,"/");

//
// Attempt to resolve the host name back into a raw IP address first
//

InetAddress aIP(host);


//
// To test for success in DNS resolution, use the GetIP() method of
// InetAddress
//

if (aIP.GetIP() == 0)
	{
	printf("\7Host not found!");
	return;
	}



printf("IP address (hex, host byte order) = %lx\n", aIP.GetIP() );
printf("IP address (dotted decimal) = %s\n\n", aIP.GetStringIP(buf));



//
// This statement connects to the remote host as a client using the IP address
// previously resolved. Note that you may also combine the DNS resolution and socket
// opening command into one statement: Socket s(host, WEB_PORT)

Socket s(aIP, WEB_PORT);

//Could also do it like this:
//Socket s(host, WEB_PORT );

//
// Check for connection to the host
//

if (s.GetStatus() == 0)
	{
	printf("Failed to connect to \"%s\"\n", host );
	return;
	}


//
// Write out request for a page
//
	else
	{
	printf("Local Port = %d\n", s.GetLocalPort() );
	InetAddress* pa = s.GetRemoteAddress();
	if (pa!=NULL)
		{
		printf("Remote IP is %s\n", pa->GetStringIP(buf) );
		delete pa;
		}

	sprintf(buf,"GET %s HTTP/1.1\r\n", pathname);
	s.Write(buf);
	s.Write("HOST: ");
	s.Write(host);
	s.Write("\r\n\r\n");

	//
	// This crude web client does not parse the HTML data received for </HTML>;
	// it just waits until the server stops sending data by getting the timeout. Not
	// a good way to do business, but works for this example.
	//

	s.SetSoTimeout(2000);

	for(nBytesReceived=0;;)	{
			nResult = s.Read(buf,sizeof(buf) -1 );

			if (nResult == Socket::SOCK_TIMEOUT) break;
			if (nResult == Socket::SOCK_ERROR) break;
			if (nResult == Socket::SOCK_NODATA) break;

			nBytesReceived+=nResult;
			buf[nResult] = 0;
			printf("%s", buf);
			}
	
	s.Close();

	printf("\n%d bytes received from host.\n", nBytesReceived);
	}




}


void UDPTest()
{
char buf[10000];
DatagramSocket ss(9999);	// Receiving socket bound to UDP port 9999
DatagramSocket st;			// Transmitting socket
int nResult;
int i;
int nTxCount;

fflush(stdin);
printf("\nUDP Broadcast test. How many broadcasts to send?");
gets(buf);
if (strlen(buf)==0) return;

nTxCount = atoi(buf);

if (ss.GetStatus()==0)
	{
	printf("Failed to bind on port 9999 for UDP.\n");
	return;
	}

if (st.GetStatus() == 0)
	{
	printf("Failed to create transmitting UDP socket.\n");
	return;
	}

printf("DatagramSocket reports MTU of %d\n", st.GetMTU() );


//
// Send a broadcast on the LAN on port 9999; then see if it is received.
//



for(i=0;i<nTxCount;i++)
	{
	sprintf(buf,"Send message # %d", i+1 );
	nResult = st.send(buf,strlen(buf),"255.255.255.255", 9999);
	printf("Send # %d\n", i);
	}

if (nResult == SOCKET_ERROR)
	{
	printf("Failed to transmit UDP packet!\n");
	return;
	}


//
// Set the timeout on the UDP receive socket. Doing this prevents the socket
// from blocking during an I/O call. This is a 1-second timeout in this example.
//

ss.SetSoTimeout(1000);

//
// UDP data sent out on LAN, count how many packets are received. The operating
// system will have already placed the packets into an input queue for reception, since
// reception is driven by interrupt from the NIC.
//

int nCount;

for(nCount=0;;nCount++)
	{
	nResult = ss.receive(buf,1024);

	if (nResult == DatagramSocket::SOCK_ERROR)
		{
		printf("Reported SOCK_ERROR\n");
		break;
		}	

	if (nResult == DatagramSocket::SOCK_TIMEOUT)
		{
		printf("Reported SOCK_TIMEOUT\n");
		break;
		}

	printf("Data received: %d bytes.\nData: ", nResult);

	// Dump the data received here

	for(i=0;i<nResult; i++)
		{
		if (i%32 == 0) printf("\n%4x: ", i);
		printf("%c", buf[i] );
		}

	printf("\n\n");
	}

// Loop broken by timeout or error, report result

printf("Got %d frames by UDP.\n", nCount );
}


int main(int argc, char* argv[])
{
char buf[1024];
int nResult;

//
// Initialize Windows sockets DLL. You *must* make this call or all calls to the
// wrapper classes will fail.
//

Socket::WSAStartup();

for(;;)
	{
	system("cls");
	printf("Hello Socket World -- Test of the Socket and DatagramSocket classes.\n\n");
	printf("1. Connect to a web server using a client Socket\n");
	printf("2. Test UDP TX & RX capabilities\n");
	printf("3. Exit this program.\n");
	printf("\nChoose?");
	fflush(stdin);
	gets(buf);
	nResult = atoi(buf);

	switch(nResult)
		{
		case 1:
			WebSurfTest();
			break;
		case 2:
			UDPTest();
			break;
		case 3:
			::WSACleanup();		// Cleanup sockets DLL workspace
			return 0;			// Normal termination here

		default: continue;
		}
	
	printf("\nPress ENTER to continue: ");
	fflush(stdin);
	gets(buf);
	}



return 0;
}

