// DatagramSocket.h: interface for the DatagramSocket class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DATAGRAMSOCKET_H__D05DBE12_30BE_440C_94F8_A7CEBBEC4485__INCLUDED_)
#define AFX_DATAGRAMSOCKET_H__D05DBE12_30BE_440C_94F8_A7CEBBEC4485__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <winsock2.h>
#include "InetAddress.h"


class DatagramSocket  
{
public:
	void UnBind();
	InetAddress* GetSenderAddress();
	int GetMTU();
	int send(void* lpBuf, int nBytes, char* szDestAddr, int nDestPort );
	void SetSoTimeout(int nTimeout);
	int receive(void* lpBuf,int nBufSize);
	int GetStatus();
	static int WSAStartup();

	static WSADATA m_Data;				// Used for WSAInit() call [Optional]

	static int SOCK_ERROR;
	static int SOCK_TIMEOUT;
	static int SOCK_NODATA;

	DatagramSocket(int nPort = 0);
	virtual ~DatagramSocket();


protected:
	int StartUDPReceiver();
	int m_nStatus;			// ZERO if object not successfully constructed; non-zero
							// if object is useable.

	SOCKET m_rcvSocket;		// SOCKET structure associated with this object

	int m_PORT;				// Port number this UDP Socket is BOUND to; or ZERO if
							// this is a transmitting UDP socket


	unsigned long m_DestIP;		// Destination IP address in binary
	SOCKADDR_IN m_destSockAddr;	// Address structure for this socket
	SOCKADDR_IN m_sourceSockAddr; // Stores source address of incoming UDP packets

};

#endif // !defined(AFX_DATAGRAMSOCKET_H__D05DBE12_30BE_440C_94F8_A7CEBBEC4485__INCLUDED_)
