// ServerSocket.h: interface for the ServerSocket class.
//
//
// To use this class, you must link to the Ws2_32.lib file (found
// under Project Settings -> Link -> Object/Library files). Also,
// you MUST make sure that <Winsock2.h> has been included.
//
// NOTE: If you use this as part of an MFC project, be sure to add
// an #include <winsock2.h> BEFORE the <stdafx.h> include, or the two
// will clash.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SERVERSOCKET_H__F67A9527_A1D9_405D_9C39_9A93DC32C0E2__INCLUDED_)
#define AFX_SERVERSOCKET_H__F67A9527_A1D9_405D_9C39_9A93DC32C0E2__INCLUDED_


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000



class ServerSocket  
{
public:
	BOOL Bind(int nPort);
	void SetSoTimeout(int nMilli);
	void Close();
	Socket* Accept();
	int GetStatus();
	ServerSocket(int nPort = 0);
	virtual ~ServerSocket();
	static WSADATA m_Data;
	int WSAStartup();

protected:
	int m_nAcceptTimeout;
	WSAEVENT m_hAcceptEvent;
	int m_nStatus;
	int StartTCPReceiver();

	SOCKET m_rcvSocket;		// SOCKET structure associated with this object
	int m_PORT;				// Port number this ServerSocket will be bound to

	
	SOCKADDR_IN m_destSockAddr;	// Address structure for this socket

};

#endif // !defined(AFX_SERVERSOCKET_H__F67A9527_A1D9_405D_9C39_9A93DC32C0E2__INCLUDED_)
