//////////////////////////////////////////////////////////////////////////
// TCPHost.cpp : Defines the entry point for the console application.
//
// This is a demonstration of how to use the CHost class in a minimal
// application.
//
// (c) 1984 - 2005 Tom A. Wheeler
//
//////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Socket.h"
#include "Host.h"


//////////////////////////////////////////////////////////////////////////
//
// TalkToClient()
//
// This method is called by the CHost framework when someone connects to
// your service. It's up to you to interact with the caller. Very important,
// you MUST check for communication errors and RETURN when that happens. Also,
// You MUST periodically check the nRunFlag to make sure that it's still OK
// to remain connected. When the StopService() method of CHost is called
// (possibly by another thread), the nRunFlag will be reset to 0.
//
//////////////////////////////////////////////////////////////////////////


void TalkToClient(Socket& s, int& nRunFlag)
{
char buf[256];
char buf2[256];
int nResult;
int i;
InetAddress* ip;
CHost aHost;			// Used only for utility (line-input) here



ip = s.GetRemoteAddress();

//
// Announce caller, and their IP address'
//

printf("\nIncoming connection from %s\n", ip->GetStringIP(buf) );


//
// Produce log-on message for caller
//

s.Write("\r\nHello, TCP World.\r\n");
s.Write("Enter your name > ");

nResult = aHost.LineInput(buf,32,1,&s,30000);

if (nResult < 0) 
		{
		printf("Error, (timeout?), returning.\n");
		return;
		}

//
// Generate formatted welcome message
//

sprintf(buf2,"Hello there, %s. What's the password?r\n\r\n>", buf);
s.Write(buf2);

nResult = aHost.LineInput(buf,32,'*',&s,30000);	// Input with password ('*') echo to caller

//
// Line-input returns < 0 when failed (timeout, carrier drop)
//

if (nResult < 0) 
		{
		printf("Error, (timeout?), returning.\n");
		return;
		}

if (strcmp(buf,"password")==0)
	{
	printf("Logged in.");
	s.Write("Congratulations!\r\n\r\n");
	//
	// Produce some sort of output for the caller
	// (your own code here)
	//
	for(i=0;i<120;i++)
		{
		sprintf(buf,"%4d",i);
		s.Write(buf);
		if (nRunFlag == 0)
			{
			s.Write("\r\nHALTED!\r\n");
			printf("HALTED!\n\n");
			return;
			}
		::Sleep(500);
		}
	s.Write("\r\n\r\nBye!\r\n");
	}

//
// When you return from TalkToClient(), the caller will be "dumped" (the socket
// is closed using RST).
//

printf("\nDumping caller.\n\n");
return;
}

//////////////////////////////////////////////////////////////////
//
// OnIdle()
//
// This method is called periodically by the CHost framework, regardless
// if a client is connected (multi-client mode) and only when awaiting
// a client connection (single-client mode).
//
// The frequency of this call is controlled by the value stored in 
// CHost member variable "m_nServerSocketTimeout", which should be
// set prior to calling StartService().
//
///////////////////////////////////////////////////////////////////


void OnIdle()
{
DatagramSocket ds;
char localIP[32];
::gethostname(localIP,sizeof(localIP)-1 );	// Get our local IP address

InetAddress ip(localIP);					// Wrap our IP address in an InetAddress object
											// which is handy for converting it to a string

char buf[1024];
char IP[32];

//
// Fill a UDP buffer with some data
//

sprintf(buf,"Advertisement: IP = %s", ip.GetStringIP(IP) );
printf(buf);

//
// Transmit this as an advertisement on the LAN on dest port 12345
//

ds.send(buf,strlen(buf)+1,"255.255.255.255", 12345 );

static int nCount = 0;

nCount++;

//
// Show the '**' or '*_' pattern, TRS-80 style, to show activity.
//

if (nCount % 2 == 0)
	{
	printf("* \r");
	}
	else
	{
	printf("**\r");
	}

}






///////////////////////////////////////////////////////////////////
//
// Main program
//
//
// Actions:
//
// 1. Uses Socket::WSAStartup() to initialize Windows Sockets 2
//
// 2. Instantiates a CHost service object that can handle up to
//    10 simultaneous clients. (This is limited only by memory.)
//
// 3. Sets the m_nServerSocketTimeout of CHost to 1000 ms, which
//    results in a call to OnIdle() every 1 s.
//
// 4. Starts the CHost service (which runs in its own thread).
//
// 5. Waits for the ENTER key to be pressed (meanwhile, the service
//    runs in its own background thread.
//
// 6. Stops the CHost service.
//
// 7. Terminates
/////////////////////////////////////////////////////////////////


int main(int argc, char* argv[])
{
int nResult;
int nPort = 5000;
CHost* pHost;
char buf[256];

if (Socket::WSAStartup())
	{
	printf("Error starting Windows sockets; aborting.\n");
	return 1;
	}

printf("Starting TCP service...");

pHost = new CHost(TalkToClient,			// Address of Client interactiion routine
					OnIdle,				// Address of OnIdle routine
					10,					// Number of clients (>1 means multi-threaded)
					nPort);				// TCP port number to bind & listen on


pHost->m_nServerSocketTimeout = 1000;	// Set timeout for Accept(), which controls
										// the rate at which OnIdle() gets called.


nResult = pHost->StartService();		// Start the service

if (nResult)
	{
	printf("Failed to start service, exiting.\n");
	return 1;
	}


printf("Started on port %d\n\n", nPort );

//
// Service started; terminate it when ENTER is pressed.
//

printf("Press ENTER to terminate service.\n\n");
fflush(stdin);
gets(buf);

printf("\nStopping Service...");
pHost->StopService();
printf("Stopped.\n\n");

//
// Clean up, exit.
//

delete pHost;
return 0;
}

