// Base64Codec.h: interface for the Base64Codec class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BASE64CODEC_H__F79F3DFA_13DE_471D_A4C2_F9F9AEAA4D94__INCLUDED_)
#define AFX_BASE64CODEC_H__F79F3DFA_13DE_471D_A4C2_F9F9AEAA4D94__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class Base64Codec  
{
public:
	int EstimateBase64DecodeSize(char* szInputString);
	int EstimateBase64EncodeSize(int nInputLength);
	int DecodeSextet(char cDatum);
	int Decode(char* szOutBuf, int nOutbufsize, const char* szInputString);
	int Encode(char* szOutbuf, int nOutbufsize, const char* szInputString, int nDataLength);
	static char* Base64Codec::LUT;
	Base64Codec();
	virtual ~Base64Codec();

protected:
	char GetSixBitsFromBuffer();
	void LoadInternalBuffer(const char* data, int nByteCount);
	int m_nBufferBitCount;			// Number of bits in internal "buffer"
	int m_nBufferNextBitPosition;	// Bit position, starting with 0
	const char* m_pCurrentBufferDatum;	// pointer to next datum (byte-oriented) in input buffer

};

#endif // !defined(AFX_BASE64CODEC_H__F79F3DFA_13DE_471D_A4C2_F9F9AEAA4D94__INCLUDED_)
